-- events 

-- strings for localization:
--
T_INVALID_PROFILE_NAME		= Localize ("Please enter unique name for your profile.");
T_NOTE										= Localize ("Note");


function OnLoad ()
	SetProperty ("/NewProfile:enable_event_on_key_down", 1);

end;


function OnEnter ()
	-- empty the editbox contents
	SetProperty ("Name:editbox.text", "");
	-- sets the edit box active for text input
	SetUIFocus ("Name"); 
	
	-- if the profile has no name (meaning no profile has been created), let's ask one
	if (GetProfileStat ("name") == "") then
		SetProperty ("Cancel:visible", 0);
	else
		SetProperty ("Cancel:visible", 1);
	end;	
end;

function OnLeave ()
end;


function OnClick (name)

	if (name == "Ok") then
		name = GetProperty ("Name:editbox.text");
		
		if (#name < 1 or IsProfileNameValid (name) == false) then
			SetProperty ("/InfoPopup/title:label.text", T_NOTE);
			SetProperty ("/InfoPopup/text:label.text", T_INVALID_PROFILE_NAME);
			PushScreen ("InfoPopup");
		else
			AddProfile (name);
			SetProfileVar ("StatTilesMatched", 0);
			SetProfileVar ("StatTotalTimePlayed", 0);
			SetProfileVar ("StatLevelsCompleted", 0);
			SetProfileVar ("StatPowerupsActivated", 0);
			SetProfileVar ("StatExpertLevelRanks", 0);
			SetProfileVar ("StatLongestChain", 0);
			PopScreen ("NewProfile");
		end;

		return;
	end;

	if (name == "Cancel") then
		PopScreen ("NewProfile");
		return;
	end;
end;


function OnKeyDown (key)
	-- Print ("OnKeyDown " .. key .. "\n");
	-- simulate pressing the ok button
	if (key == "RETURN") then
		OnClick ("Ok");
	end;
	
	return 1; -- return 1 (true) meaning that we process 
end;




	

LuaInclude ("ui/common-ui-funcs.lua");

function OnUpdate (tdelta)

	-- temporary hack to keep the text feed focus on the editbox in all cases
	SetUIFocus ("Name");
	
	DoPanelTransition ("fader", "panel");
	
end;

function OnDraw ()

end;
